/*
 * yahoo_search_api.js
 * Part of the Yahoo! Search Sidebar for Firefox
 * powered by Yahoo! Search web services (http://api.search.yahoo.com)
 * Written by Marc Abramowitz (http://marc.abramowitz.info)
 */

function Yahoo_Search() {}

Yahoo_Search.baseURL = function() {
  return "http://search.yahooapis.com/WebSearchService/V1/";
}

Yahoo_Search.appid = function() {
  return "YahooSearchSidebar";
}

Yahoo_Search.baseArgs = function() {
  return "appid=" + this.appid();
}

Yahoo_Search.Results = function(args) {
  var xmlUrl = this.baseURL() + "webSearch?" 
       + this.baseArgs()
       + "&query=" + args["Doc"] 
       + "&zip=" 
       + "&start=" + args["First"] 
       + "&results=" + args["Count"];
  var xmlhttp = new XMLHttpRequest();
  xmlhttp.open("GET", xmlUrl, false);
  xmlhttp.send(null);
  return this.readXML(xmlhttp.responseXML);
}

Yahoo_Search.readXML = function(xmlDoc) {
  try {
    var retVal = new Array();
    var resultSet = xmlDoc.getElementsByTagName("ResultSet")[0];                                                              
    var totalResultsAvailable = parseInt(resultSet.getAttribute("totalResultsAvailable"));  
    var totalResultsReturned = parseInt(resultSet.getAttribute("totalResultsReturned"));                                      
    var firstResultPosition = parseInt(resultSet.getAttribute("firstResultPosition"));                                        
    var start = firstResultPosition;                                                                                          
    var end = firstResultPosition + totalResultsReturned - 1;                                                                 
                                                                                                                              
    var results = xmlDoc.getElementsByTagName("Result"); 
    for (var i = 0; i < results.length; i++) {                                                                                
      var result = results[i];                                                                                                
      var title = result.getElementsByTagName('Title')[0].firstChild.nodeValue;
      var summary = '';
      if (result.getElementsByTagName('Summary')[0].firstChild) {
        summary = result.getElementsByTagName('Summary')[0].firstChild.nodeValue;
      }
      var clickUrl = result.getElementsByTagName('ClickUrl')[0].firstChild.nodeValue;
      var url = result.getElementsByTagName('Url')[0].firstChild.nodeValue;
      retVal[i] = { I: start + i, Title: title, Summary: summary, ClickUrl: clickUrl, Url: url };
    }

    return retVal;
  } catch(exception) {
    alert('Exception occurred while reading XML (i=' + i + '; start=' + start + ';end=' + end + '): ' + exception);
  }
}
