/*
 * yahoo_search_sidebar.js
 * Part of the Yahoo! Search Sidebar for Firefox
 * powered by Yahoo! Search web services (http://api.search.yahoo.com)
 * Written by Marc Abramowitz (http://marc.abramowitz.info)
 */

var yahoo_search_sidebar = {

    lastQueryTerm               : "",
    main                        : function() {},
    focusTerms                  : function() {
        var obj = document.getElementById('find-text');
        obj.focus();
        obj.select();
    },
    getPageNum                  : function() { return parseInt(document.getElementById("page-num").value); },
    setPageNum                  : function(inPageNum) { document.getElementById("page-num").value = inPageNum; },
    setNavButtons               : function() {
        var pageNum = this.getPageNum();
        var prevButtonState = (pageNum > 1);
        var nextButtonState = (pageNum < 10);
        document.getElementById("prev-btn").disabled = !prevButtonState;
        document.getElementById("next-btn").disabled = !nextButtonState;
    },
    prevPage                    : function() {
        this.setPageNum(this.getPageNum() - 1);
        this.newSearch();
    },
    nextPage                    : function() {
        this.setPageNum(this.getPageNum() + 1);
        this.newSearch();
    },
    newSearch                   : function() {
        this.setNavButtons();
        document.persist("find-text", "value");
        var queryTerm = document.getElementById("find-text").value;
        document.getElementById("powered-by-link").href = "http://search.yahoo.com/search?appid=YahooSearchSidebar&p=" + queryTerm;
        var pageNum = this.getPageNum();
        var first = (pageNum - 1) * 30 + 1;
        if (1 || queryTerm != this.lastQueryTerm) {
            var results = Yahoo_Search.Results({
                Doc:          queryTerm,
                // The following are optional.
                // Values shown are defaults.
                Mode:         "all",
                Count:        30,
                First:        first,
                Type:         "all",
                AllowAdult:   0,
                AllowSimilar: 0,
                Language:     "undef",
            });
            this.populateTree(results);
        }

        this.lastQueryTerm = queryTerm;
    },
    cleanupForDisplayInXULTree  : function(str) {
        str = str.split("\xd2").join("\"");
        str = str.split("\xd3").join("\"");
        return htmlDecode(str);
    },
    populateTree                : function(results) {      
        // need to clear currentIndex before clearing the tree to avoid an exception
        var tree = document.getElementById('result-tree');
        tree.currentIndex = 0;

        // remove all the existing data
        var el = document.getElementById("result-tree-children");
        while (el.hasChildNodes()) el.removeChild(el.lastChild);

        for (var i = 0; i < results.length; i++) {                                                                                
            var result = results[i];
            var index = result["I"];                                       
            var title = this.cleanupForDisplayInXULTree(result["Title"]);
            var summary = this.cleanupForDisplayInXULTree(result["Summary"]);
            var clickUrl = result["ClickUrl"];
            var url = result["Url"];

            // dump("yahoo_search_sidebar.js: result " + index + ": \"" + title + "\"; summary = \"" + summary + "\"\n");

            var treeItem = document.createElement("treeitem");
            treeItem.setAttribute("clickUrl", clickUrl);
            treeItem.setAttribute("tooltipText", summary);
            document.getElementById("result-tree-children").appendChild(treeItem);
            var treeRow = document.createElement("treerow");
            treeItem.appendChild(treeRow);
            var treeCell1 = document.createElement("treecell");
            treeCell1.setAttribute("label", index);
            treeRow.appendChild(treeCell1);
            var treeCell2 = document.createElement("treecell");
            treeCell2.setAttribute("label", title);
            treeRow.appendChild(treeCell2);
            var treeCell3 = document.createElement("treecell");
            treeCell3.setAttribute("label", summary);
            treeRow.appendChild(treeCell3);
            var treeCell4 = document.createElement("treecell");
            treeCell4.setAttribute("label", url);
            treeRow.appendChild(treeCell4);
        }
    },
    showSelected   : function() {
        var tree = document.getElementById('result-tree');
        if (tree.currentIndex >= 0) {
            var treechildren = document.getElementById('result-tree-children');
            var item = treechildren.childNodes[tree.currentIndex];
            var clickUrl = item.getAttribute("clickUrl");
            top.content.window.location = clickUrl;
        }
    }

}
